
SELECT tsystem.function__drop_by_regex( 'auditlog__table__ident', 'tlog', _commit => true );
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ab2 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'a2_ab_ix' )  , _tab.a2_ab_ix ),
                              concat_ws( ' = ', GetFieldAlias( 'a2_n' ), _tab.a2_n )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ab2ba ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT  a2_ab_ix FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ),
                             ( SELECT  a2_ks    FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ),
                             ( SELECT  a2_n     FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ),
                             _tab.a2ba_ak_nr
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab abk ) RETURNS VARCHAR AS $$
       SELECT concat_ws( ' = ', GetFieldAlias( 'ab_ix' ), _tab.ab_ix );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab adk ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'ad_krz' ), _tab.ad_krz );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab adk_adresses ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'ada_ad_krz' ), _tab.ada_ad_krz ),
                             _tab.ada_fa1, _tab.ada_str, _tab.ada_plz, _tab.ada_ort );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab adk1 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'a1_krz' ), _tab.a1_krz ),
                             concat_ws( ' = ', GetFieldAlias( 'a1_knr' ), _tab.a1_knr )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab adk2 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'a2_krz' ), _tab.a2_krz ),
                             concat_ws( ' = ', GetFieldAlias( 'a2_knr' ), _tab.a2_knr )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab adkap ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'ap_ad_krz' ), _tab.ap_ad_krz ),
                             _tab.ap_name, _tab.ap_vorn );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab anl ) RETURNS VARCHAR AS $$
       SELECT concat_ws(  '  =  ',  GetFieldAlias(  'an_nr'  ),  _tab.an_nr  );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab art ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ak_nr, _tab.ak_bez );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artblang ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.akbl_ak_nr, _tab.akbl_spr_key );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artcod ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ac_n );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artcodlang ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.acl_ac_n, _tab.acl_spr_key );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artdlang ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.akdl_ak_nr, _tab.akdl_spr_key );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artdokutxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.adtx_ak_nr, _tab.adtx_spr_key );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artinfo ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ain_ak_nr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artmlang ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.akml_ak_nr, _tab.akml_spr_key );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artoption_arts ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.aoa_pos, _tab.aoa_g_ak_nr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artpr ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.pr_id, _tab.pr_aknr, _tab.pr_pmnr, _tab.pr_mebe );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artpruefung ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.apr_pos, _tab.apr_aknr, _tab.apr_ac );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artpruefungtest ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'aprt_pos' ), _tab.aprt_pos ),
                             ( SELECT apr_aknr FROM artpruefung WHERE apr_id = _tab.aprt_apr_id ),
                             ( SELECT apr_ac   FROM artpruefung WHERE apr_id = _tab.aprt_apr_id ),
                             substring( _tab.aprt_txt, 50 )
                        );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artrab ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'rab_aknr' ), _tab.rab_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artstp ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'astp_aknr' ), _tab.astp_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artvkp ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.vkp_aknr, _tab.vkp_kukl );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artzuo ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.az_pronr, _tab.az_prokrz, _tab.az_kunr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab artzust ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.az_aknr, _tab.az_ll_db_usename );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab auftg ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ag_astat, _tab.ag_nr, _tab.ag_pos, _tab.ag_lkn, _tab.ag_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab auftgabzu ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'az_pos' ), _tab.az_pos ),
                             ( SELECT ag_astat  FROM auftg WHERE ag_id  = _tab.az_ag_id ),
                             ( SELECT ag_nr     FROM auftg WHERE ag_id  = _tab.az_ag_id ),
                             ( SELECT ag_pos    FROM auftg WHERE ag_id  = _tab.az_ag_id ),
                             ( SELECT abz_txt   FROM abzu  WHERE abz_id = _tab.az_abz_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab auftgdokutxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'atd_titel' ), substr( _tab.atd_titel, 1, 50 ) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab auftgmatinfo ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'agmi_id' ), _tab.agmi_id ),
                             ( SELECT ag_astat  FROM auftg WHERE ag_id = _tab.agmi_ag_id ),
                             ( SELECT ag_nr     FROM auftg WHERE ag_id = _tab.agmi_ag_id ),
                             ( SELECT ag_pos    FROM auftg WHERE ag_id = _tab.agmi_ag_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bdea ) RETURNS VARCHAR AS $$
      SELECT  concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'ba_id' )  , _tab.ba_id ),
                             concat_ws( ' = ', GetFieldAlias( 'ba_minr' ), _tab.ba_minr ),
                             _tab.ba_anf,
                             _tab.ba_end
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bdeabgruende ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                              _tab.ab_id,
                              concat_ws( ' = ', GetFieldAlias( 'ab_grup' )  , _tab.ab_grup ),
                              concat_ws( ' = ', GetFieldAlias( 'ab_txt' ), substring( _tab.ab_txt from 1 for 20 ) )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bdep ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'll_ad_krz' ), ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.bd_minr ) ),
                              concat_ws( ' = ', GetFieldAlias( 'bd_minr' )  , _tab.bd_minr ),
                              concat_ws( ' = ', GetFieldAlias( 'bd_anf' ), _tab.bd_anf )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bdepab ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'bdab_minr' ), ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.bdab_minr ) ),
                              concat_ws( ' = ', GetFieldAlias( 'bdab_minr' )  , _tab.bdab_minr ),
                              concat_ws( ' = ', GetFieldAlias( 'bdab_anf' ), _tab.bdab_anf )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tartikel.beleg_k__artchange ) RETURNS VARCHAR AS $$
    SELECT concat_ws( ', ', _tab.k_tablename, _tab.k_kba_key, _tab.k_code, _tab.k_nummer, _tab.k_ad_krz );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tartikel.beleg_p__artchange ) RETURNS VARCHAR AS $$
    SELECT concat_ws( ', ', _tab.p_tablename, _tab.p_k_code, _tab.p_k_nummer, _tab.p_pos, _tab.p_aknr );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tartikel.beleg_p__artchange__vorkalk ) RETURNS VARCHAR AS $$
    SELECT concat_ws( ', ', _tab.p_tablename, _tab.p_k_code, _tab.p_k_nummer, _tab.p_pos, _tab.p_aknr );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belegabzu ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ),
                             ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ),
                             ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ),
                             _tab.belaz_type,
                             _tab.belaz_pos,
                             ( SELECT abz_txt           FROM abzu          WHERE abz_id  = _tab.belaz_abzu_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belegdokument ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.beld_belegtyp, _tab.beld_dokunr, _tab.beld_krzbesteller, _tab.beld_erstelldatum );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belegpos ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ),
                             ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ),
                             _tab.belp_pos,
                             ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ),
                             _tab.belp_aknr
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belegposabzu ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ),
                             ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ),
                             ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ),
                             ( SELECT belp_aknr         FROM belegpos      WHERE belp_id = _tab.belpaz_belegpos_id ),
                             ( SELECT abz_txt           FROM abzu          WHERE abz_id  = _tab.belpaz_abzu_id )
 
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belkopf ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.be_bnr, _tab.be_prof, _tab.be_rkrz );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belzeil_auftg_lif ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.bz_be_bnr, _tab.bz_pos, _tab.bz_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab belzeil_grund ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.bz_be_bnr, _tab.bz_pos, _tab.bz_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bestanfpos ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'bap_banr' ), _tab.bap_banr ),
                             concat_ws( ' = ', GetFieldAlias( 'bap_pos'  ), _tab.bap_pos )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bestanftxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'ba_nr' ), _tab.ba_nr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab bewa ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'wa_einh' ), _tab.wa_einh );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab eingrechdokument ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.beld_belegtyp, _tab.beld_dokunr, _tab.beld_krzbesteller, _tab.beld_krzlieferung );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab epreis ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.e_aknr, _tab.e_lkn );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab epreisabzu ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT e_aknr  FROM epreis WHERE e_id = _tab.eaz_e_id ),
                             ( SELECT e_lkn   FROM epreis WHERE e_id = _tab.eaz_e_id ),
                             _tab.eaz_type,
                             _tab.eaz_pos,
                             ( SELECT abz_txt FROM abzu   WHERE abz_id  = _tab.eaz_abz_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab epreisstaffel ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT e_aknr  FROM epreis WHERE e_id = _tab.est_e_id ),
                             ( SELECT e_lkn   FROM epreis WHERE e_id = _tab.est_e_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab eprzutxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ezt_aknr, _tab.ezt_lkn, substring( _tab.ezt_info, 1, 50 ) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab invrech ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'ir_id' )  , _tab.ir_id ),
                             _tab.ir_an_nr,
                             _tab.ir_date
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab karenz ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'kr_tpl_name' )  , _tab.kr_tpl_name ),
                             concat_ws( ' = ', GetFieldAlias( 'kr_newtime' ), _tab.kr_newtime ),
                             concat_ws( ' = ', GetFieldAlias( 'kr_anf' ), _tab.kr_anf ),
                             concat_ws( ' = ', GetFieldAlias( 'kr_end' ), _tab.kr_end )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ksv ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'ks_abt' )  , _tab.ks_abt );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ksv_werkzeuge ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ksw_ks_abt, _tab.ksw_ak_nr, substring( _tab.ksw_txt, 1, 50 ) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab kundanfrage ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.kanf_nr, _tab.kanf_ak_nr, _tab.kanf_ad_krz );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab kundanfragepos ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.kanfp_kanf_nr, _tab.kanfp_pos, _tab.kanfp_ak_nr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab lagartikelkonf ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.lgoa_aknr, _tab.lgoa_lgo_name );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ldsabzu ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT ld_code  FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ),
                             ( SELECT ld_pos   FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ),
                             ( SELECT ld_kn    FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ),
                             ( SELECT ld_aknr  FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ),
                             _tab.ldaz_type,
                             _tab.ldaz_pos,
                             ( SELECT abz_txt  FROM abzu   WHERE abz_id = _tab.ldaz_abz_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ldsdok ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ld_code, _tab.ld_auftg, _tab.ld_pos, _tab.ld_kn, _tab.ld_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ldsdokdokutxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'ltd_dokunr' )  , _tab.ltd_dokunr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ldsdoktxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.ldt_code,_tab.ldt_auftg, substring( _tab.ldt_txt, 1, 50 ) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab lifschpack ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.lp_l_dokunr, _tab.lp_aknr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab llv ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'll_minr' )  , _tab.ll_minr ),
                              concat_ws( ' = ', GetFieldAlias( 'll_ad_krz' ), _tab.ll_ad_krz )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab llv_stuko_history ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'll_ad_krz' ), ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.llsh_ll_minr ) ),
                              concat_ws( ' = ', GetFieldAlias( 'll_minr' )  , _tab.llsh_ll_minr),
                              concat_ws( ' = ', GetFieldAlias( 'llsh_monthyear' ), _tab.llsh_monthyear)
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab mitpln ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.mpl_formonth, _tab.mpl_date, _tab.mpl_minr, _tab.mpl_tpl_name );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ncp_o2_a2_ksv ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             GetFieldAlias('o2_ix')     || '=' || ( SELECT o2_ix  FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ) || ' / ' || ( SELECT op_n FROM opl WHERE op_ix = ( SELECT o2_ix  FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ) ),
                             GetFieldAlias('o2_n')      || '=' || ( SELECT o2_n   FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ),
                             GetFieldAlias('o2_ks')     || '=' || ( SELECT o2_ks   FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ),
                             GetFieldAlias('o2_nc')     || '=' || ( SELECT o2_nc   FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ),
                             GetFieldAlias('ncpoak_ks') || '=' || _tab.ncpoak_ks,
                             GetFieldAlias('ncp_ncnr')  || '=' || ( SELECT ncp_ncnr   FROM ncprogram WHERE ncp_id = _tab.ncpoak_ncp_id )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab ncprogram ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             GetFieldAlias('o2_ix')     || '=' || ( SELECT o2_ix    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id )|| ' / ' || ( SELECT op_n FROM opl WHERE op_ix =  ( SELECT o2_ix    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ) ),
                             GetFieldAlias('o2_n')      || '=' || ( SELECT o2_n     FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ),
                             GetFieldAlias('o2_ks')     || '=' || ( SELECT o2_ks    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ),
                             GetFieldAlias('o2_nc')     || '=' || ( SELECT o2_nc    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ),
                             GetFieldAlias('ncpoak_ks') || '=' || ( SELECT ncpoak_ks FROM ncp_o2_a2_ksv WHERE ncpoak_ncp_id = _tab.ncp_id ), ---_tab.ncpoak_ks,
                             GetFieldAlias('ncp_ncnr')  || '=' || _tab.ncp_ncnr
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op2 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.o2_ix, ( SELECT op_n FROM opl WHERE op_ix = _tab.o2_ix ), _tab.o2_n, substring( _tab.o2_txt, 1, 50 ) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op2ba ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             _tab.o2ba_ix,
                             ( SELECT op_n  FROM opl WHERE op_ix   = _tab.o2ba_ix ),
                             _tab.o2ba_n,
                             _tab.o2ba_ak_nr
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op2ksa ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                             GetFieldAlias('o2_ix')    || '=' || o2_ix   || ' / ' || op_n,
                             GetFieldAlias('o2_n')     || '=' || o2_n,
                             GetFieldAlias('o2_ks')    || '=' || o2_ks,
                             GetFieldAlias('o2_nc')    || '=' || o2_nc,
                             GetFieldAlias('o2ks_ks')  || '=' || o2ks_ks,
                             GetFieldAlias('ncp_ncnr') || '=' || ncp_ncnr
                      )
     FROM op2ksa 
       LEFT JOIN op2 ON o2_id = o2ks_o2_id
       LEFT JOIN opl ON op_ix = o2_ix
       LEFT JOIN ncp_o2_a2_ksv ON ncpoak_o2_id = o2ks_o2_id AND o2ks_ks = ncpoak_ks
     LEFT JOIN ncprogram ON ncpoak_ncp_id = ncp_id 
     WHERE 
     o2ks_o2_id = _tab.o2ks_o2_id AND o2ks_ks = _tab.o2ks_ks
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op3 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.o3_ix, ( SELECT op_n FROM opl WHERE op_ix = _tab.o3_ix ), _tab.o3_pos );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op5 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT o2_ix  FROM op2 WHERE o2_ix   = _tab.o5_o2_id ),
                             ( SELECT op_n   FROM opl WHERE op_ix   = ( SELECT o2_ix  FROM op2 WHERE o2_id   = _tab.o5_o2_id ) ),
                             ( SELECT o2_n   FROM op2 WHERE o2_ix   = _tab.o5_o2_id ),
                             _tab.o5_wz_aknr
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op6 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             _tab.o6_ix,
                             ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o6_ix ),
                             _tab.o6_o2_n,
                             concat_ws( ' = ', GetFieldAlias( 'o6_pos' ), _tab.o6_pos ),
                             _tab.o6_aknr
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op7 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             _tab.o7_op_ix,
                             ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o7_op_ix ),
                             _tab.o7_m,
                             substr( _tab.o7_txt, 1, 50 )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op7zko ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             _tab.o7zk_ix,
                             ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o7zk_ix ),
                             substr( _tab.o7zk_krc_bez, 1, 50 )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab op8 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             _tab.o8_ix,
                             ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o8_ix ),
                             _tab.o8_op_stat,
                             _tab.o8_pos
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab opl ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'op_ix' ), _tab.op_ix ),
                             concat_ws( ' = ', GetFieldAlias( 'op_n' ) , _tab.op_n )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab oplpm_data ) RETURNS VARCHAR AS $$
     SELECT  concat_ws( ', ', 
                              concat_ws(  ' = ',  GetFieldAlias( 'o2_ix'   ), ( SELECT o2_ix FROM op2 WHERE o2_id = _tab.pm_op2_id ) ),
                              concat_ws(  ' =  ',  GetFieldAlias( 'o2_n'    ), ( SELECT o2_n  FROM op2 WHERE o2_id = _tab.pm_op2_id ) ),
                              concat_ws(  ' = ',  GetFieldAlias( 'pm_pmnr' ), _tab.pm_pmnr ),
                              concat_ws(  ' = ',  GetFieldAlias( 'pm_nenn' ), _tab.pm_nenn )
                      );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab oplpm_mw ) RETURNS VARCHAR AS $$
        SELECT concat_ws( ', ',
                               concat_ws( ' = ', GetFieldAlias( 'ab_ix'      ) ,  ( SELECT a2_ab_ix FROM ab2        WHERE a2_id = _tab.mw_pm_id ) ),
                               concat_ws( ' = ', GetFieldAlias( 'a2_n'       ) ,  ( SELECT a2_n     FROM ab2        WHERE a2_id = _tab.mw_pm_id ) ),
                               concat_ws( ' = ', GetFieldAlias( 'pm_pmnr'    ) ,  ( SELECT pm_pmnr  FROM oplpm_data WHERE pm_id = _tab.mw_pm_id ) ),
                               concat_ws( ' = ', GetFieldAlias( 'mw_pr_pmnr' ) ,  _tab.mw_pr_pmnr ),
                               concat_ws( ' = ', GetFieldAlias( 'mw_pruefer' ) ,  _tab.mw_pruefer ),
                               _tab.mw_pruefzeit
                       );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab personal ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ' = ', GetFieldAlias( 'pers_krz' ), _tab.pers_krz );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab qab ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.q_nr, _tab.q_typ, _tab.q_ak_nr, _tab.q_krzl );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab qabteam ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.qteam_qnr, _tab.qteam_minr );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab recnogroup ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.reg_tablename, _tab.reg_pname );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab recnokeyword ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'r_dbrid' ), _tab.r_dbrid ),
                             _tab.r_tablename,
                             _tab.r_reg_pname
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab settings ) RETURNS VARCHAR AS $$
             SELECT  coalesce( _tab.s_vari,  ( SELECT sd_name FROM SettingsDyn WHERE _tab.s_vari = sd_settingsname ),  '***'  );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab softlink ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                              concat_ws( ' = ', GetFieldAlias( 'slink_bez' )  , _tab.slink_bez ),
                              concat_ws( ' = ', GetFieldAlias( 'slink_table' )  , _tab.slink_table ),
                              concat_ws( ' = ', GetFieldAlias( 'slink_type' ), _tab.slink_type )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab stundauszahl ) RETURNS VARCHAR AS $$
     SELECT concat_ws( ', ',
                              _tab.sa_id,
                              concat_ws( ' = ', GetFieldAlias( 'll_ad_krz' ), ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.sa_minr ) ),
                              concat_ws( ' = ', GetFieldAlias( 'sa_minr' ), _tab.sa_minr ),
                              concat_ws( ' = ', GetFieldAlias( 'sa_date' ), _tab.sa_date)
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab stv ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.st_n, _tab.st_pos );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab stv_op2 ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             ( SELECT st_n   FROM stv WHERE st_id   = _tab.sto2_st_id ),
                             ( SELECT st_pos FROM stv WHERE st_id   = _tab.sto2_st_id ),
                             concat_ws( ' = ', GetFieldAlias( 'o2_ix' ), ( SELECT o2_ix  FROM op2 WHERE o2_id   = _tab.sto2_o2_id ) ),
                             ( SELECT o2_n   FROM op2 WHERE o2_id   = _tab.sto2_o2_id )
                     );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab stvrevision ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.str_revnr, _tab.str_resid, substr(_tab.str_txt, 1, 50) );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab stvzutxt ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.stv_zn, substr( _tab.stv_txt, 1, 50 ), _tab.stv_stat );
   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tplan ) RETURNS VARCHAR AS $$
      SELECT  concat_ws( ' = ', GetFieldAlias( 'tpl_name' ), _tab.tpl_name );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tplanblock ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'tplbl_tpl_name' )  , _tab.tplbl_tpl_name ),
                             concat_ws( ' = ', GetFieldAlias( 'tplbl_begin' ), _tab.tplbl_begin ),
                             concat_ws( ' = ', GetFieldAlias( 'tplbl_end' ), _tab.tplbl_end )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab tplanpause ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ',
                             concat_ws( ' = ', GetFieldAlias( 'tplp_tpl_name' )  , _tab.tplp_tpl_name ),
                             concat_ws( ' = ', GetFieldAlias( 'tplp_begin' ), _tab.tplp_begin ),
                             concat_ws( ' = ', GetFieldAlias( 'tplp_end' ), _tab.tplp_end )
                     );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab werkzeug ) RETURNS VARCHAR AS $$
      SELECT concat_ws( ', ', _tab.wz_id, _tab.wz_aknr, _tab.wz_wznr, _tab.wz_hest );
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident( IN _tab werkzeug_link ) RETURNS VARCHAR AS $$
 SELECT  concat_ws(',',
         concat_ws('=', trim( GetFieldAlias('ESL_TYP')), trim((SELECT wz_aknr FROM werkzeug WHERE wz_id = _tab.wzl_wz_id))),
         concat_ws('=', GetFieldAlias('wzl_table'), _tab.wzl_table),
         concat_ws('=', GetFieldAlias('wzl_pkey'), _tab.wzl_pkey),
         concat_ws('=', GetFieldAlias('ESL_ID'), (SELECT wz_wznr FROM werkzeug WHERE wz_id = _tab.wzl_wz_id))
         ); 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
